#!/usr/bin/perl
# 
# $Header: has/demo/crs/coldfailover/osds/act_listener.pl /unix/4 2009/06/02 01:42:54 rknapp Exp $
#
# act_listener.pl
# 
# Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      act_listener.pl - action script for the listener resource
#
#    DESCRIPTION
#      This perl script is the action script for start / stop / check
#      the Oracle Listener in a cold failover configuration.
#
#    NOTES
#      Edit the perl installation directory as appropriate.
#
#      Place this file in <CRS_HOME>/crs/public/
#
#    MODIFIED   (MM/DD/YY)
#    rknapp      05/19/09 - add clean part                         
#    rknapp      05/14/09 - make the script more Solaris friendly
#    rknapp      06/24/07 - fixed bug with multiple listener
#    rvenkate    04/05/07 - checkin as demo
#    pnewlan     01/17/07 - Use Environment variables rather than hard code 
#                           HOME & LISTENER
#    pnewlan     11/23/06 - oracle OS user invoker and listener name
#    rknapp      05/22/06 - Creation
# 

$ORACLE_HOME = "$ENV{_USR_ORA_LANG}";
$ORA_LISTENER_NAME = "$ENV{_USR_ORA_SRV}";

if ($#ARGV != 0 ) {
        print "usage: start stop check required \n";
exit;
}

$command = $ARGV[0];

# start listener
if ($command eq "start") {
        system ("
        ORACLE_HOME=$ORACLE_HOME
        export ORACLE_HOME
        ORA_LISTENER_NAME=$ORA_LISTENER_NAME
        export ORA_LISTENER_NAME
#       export TNS_ADMIN=$ORACLE_HOME/network/admin  # optionally set TNS_ADMIN here
        $ORACLE_HOME/bin/lsnrctl start $ORA_LISTENER_NAME");
        }
# stop listener
if ($command eq "stop") {
        system ("
        ORACLE_HOME=$ORACLE_HOME
        export ORACLE_HOME
        ORA_LISTENER_NAME=$ORA_LISTENER_NAME
        export ORA_LISTENER_NAME
#       export TNS_ADMIN=$ORACLE_HOME/network/admin  # optionally set TNS_ADMIN here
        $ORACLE_HOME/bin/lsnrctl stop $ORA_LISTENER_NAME");
        }
# check listener
if ($command eq "check") {
        check_listener();
        }

sub check_listener {
        my($check_proc_listener,$process_listener) = @_;
        $process_listener = "$ORACLE_HOME/bin/tnslsnr $ORA_LISTENER_NAME -inherit";
        $check_proc_listener = qx(ps -ae -o args | grep -w "tnslsnr $ORA_LISTENER_NAME" | grep -v grep | head -n 1 );
        chomp($check_proc_listener);
        if ($process_listener eq $check_proc_listener) {
                exit 0;
        } else {
                exit 1;
                }
        }
# clean listener
if ($command eq "clean") {
        my $kill_proc = qx(ps -aef | grep -w "tnslsnr $ORA_LISTENER_NAME" | grep -v grep | head -n 1 | awk '{print \$2}'| xargs kill -9 $1);
        exit 0;
}
